/*
 * Decompiled with CFR 0.152.
 */
package vazkii.botania.common.handler;

import java.util.Collections;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.WeakHashMap;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.world.level.Level;
import vazkii.botania.api.internal.IManaNetwork;
import vazkii.botania.api.mana.IManaCollector;
import vazkii.botania.api.mana.IManaPool;
import vazkii.botania.api.mana.IManaReceiver;
import vazkii.botania.api.mana.ManaBlockType;
import vazkii.botania.api.mana.ManaNetworkAction;
import vazkii.botania.common.helper.MathHelper;

public final class ManaNetworkHandler
implements IManaNetwork {
    public static final ManaNetworkHandler instance = new ManaNetworkHandler();
    private final Map<Level, Set<IManaPool>> manaPools = new WeakHashMap<Level, Set<IManaPool>>();
    private final Map<Level, Set<IManaCollector>> manaCollectors = new WeakHashMap<Level, Set<IManaCollector>>();

    public void onNetworkEvent(IManaReceiver thing, ManaBlockType type, ManaNetworkAction action) {
        switch (type) {
            case COLLECTOR: {
                if (action == ManaNetworkAction.ADD) {
                    this.add(this.manaCollectors, thing.getManaReceiverLevel(), (IManaCollector)thing);
                    break;
                }
                this.remove(this.manaCollectors, thing.getManaReceiverLevel(), (IManaCollector)thing);
                break;
            }
            case POOL: {
                if (action == ManaNetworkAction.ADD) {
                    this.add(this.manaPools, thing.getManaReceiverLevel(), (IManaPool)thing);
                    break;
                }
                this.remove(this.manaPools, thing.getManaReceiverLevel(), (IManaPool)thing);
            }
        }
    }

    @Override
    public void clear() {
        this.manaPools.clear();
        this.manaCollectors.clear();
    }

    @Override
    public IManaPool getClosestPool(BlockPos pos, Level world, int limit) {
        if (this.manaPools.containsKey(world)) {
            return this.getClosest(this.manaPools.get(world), pos, limit);
        }
        return null;
    }

    @Override
    public IManaCollector getClosestCollector(BlockPos pos, Level world, int limit) {
        if (this.manaCollectors.containsKey(world)) {
            return this.getClosest(this.manaCollectors.get(world), pos, limit);
        }
        return null;
    }

    public boolean isCollectorIn(Level level, IManaCollector collector) {
        return this.manaCollectors.getOrDefault(level, Collections.emptySet()).contains(collector);
    }

    public boolean isPoolIn(Level level, IManaPool pool) {
        return this.manaPools.getOrDefault(level, Collections.emptySet()).contains(pool);
    }

    @Nullable
    private <T extends IManaReceiver> T getClosest(Set<T> receivers, BlockPos pos, int limit) {
        long minDist = Long.MAX_VALUE;
        long limitSquared = (long)limit * (long)limit;
        IManaReceiver closest = null;
        for (IManaReceiver receiver : receivers) {
            long distance = MathHelper.distSqr((Vec3i)receiver.getManaReceiverPos(), (Vec3i)pos);
            if (distance > limitSquared || distance >= minDist) continue;
            minDist = distance;
            closest = receiver;
        }
        return (T)closest;
    }

    private <T> void remove(Map<Level, Set<T>> map, Level level, T thing) {
        if (!map.containsKey(level)) {
            return;
        }
        Set<T> set = map.get(level);
        set.remove(thing);
        if (set.isEmpty()) {
            map.remove(level);
        }
    }

    private <T> void add(Map<Level, Set<T>> map, Level level, T thing) {
        map.computeIfAbsent(level, k -> new HashSet()).add(thing);
    }

    @Override
    public Set<IManaCollector> getAllCollectorsInWorld(Level world) {
        return this.getAllInWorld(this.manaCollectors, world);
    }

    @Override
    public Set<IManaPool> getAllPoolsInWorld(Level world) {
        return this.getAllInWorld(this.manaPools, world);
    }

    private <T> Set<T> getAllInWorld(Map<Level, Set<T>> map, Level world) {
        Set<T> ret = map.get(world);
        if (ret == null) {
            return Collections.emptySet();
        }
        return Collections.unmodifiableSet(ret);
    }
}

